
#include <xc.h>
#include <stdlib.h>
#include "includes.h"





// CONFIG1
#pragma config FOSC = INTOSC    // Oscillator Selection (INTOSC oscillator: I/O function on CLKIN pin)
#pragma config WDTE = OFF    // Watchdog Timer Enable (WDT controlled by the SWDTEN bit in the WDTCON register)
#pragma config PWRTE = ON       // Power-up Timer Enable (PWRT enabled)
#pragma config MCLRE = ON            // MCLR Pin Function Select (MCLR/VPP pin function is MCLR)
#pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Memory Code Protection (Data memory code protection is disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
#pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = ON        //  (Internal/External Switchover mode is enabled)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)
// CONFIG2
#pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
#pragma config VCAPEN = OFF     // Voltage Regulator Capacitor Enable (All VCAP pin functionality is disabled)
#pragma config PLLEN = ON       // PLL Enable (4x PLL enabled)
#pragma config STVREN = ON      //  (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
#pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
//END CONFIG//////////////////////////////////////////////////////////////////////////

__EEPROM_DATA(0x00, 0x01, 0x63, 0x00, 0x28, 0x00, 0x00, 0x00);  //00 to 0x7
__EEPROM_DATA(0x00, 0x00, 0x00, 0x03, 0xC8, 0x00, 0x01, 0x00);  //0x8 to 0xF
// PRELOAD eeprom: 01. Tx learn, 02 Edge Exclusion zone, 03 Run Modes, 04 Run Timer, 05 Safety on/off, 06 Cycle Counter lower bits, 07 Cycle counter (higher bits)
// PRELOAD eeprom: 08. OPEN TIME, 09, Current Sensor on / off, 10, monitor type, 11 Light period, 12 stored current detect 13 *** 14 Reverse method   15 PEC_setting


// Second row is 0x08 ff
// enter values into above as Hex

// VARIABLES ************************************************************
char post_reset;
extern unsigned char __resetbits;
extern bit __powerdown;
extern bit __timeout;
unsigned char encoder_A;
unsigned char encoder_B;

char move_down_flag = 0; 
char end_close = 0; 
char limit_setting;
char status_a1;
char status_b1;
char status_a2;
char status_b2;
unsigned char clockwise;
unsigned char timer;
unsigned char check;
char change = 0;
unsigned char timer2;



// char runmenu  - - is for clearing the screen at the end of a run

// END VARIABLES ********************************************************


// the programming menu is accessed when function() is read and button pressed

//--------------------------------------------------------------------
// Internal Function Prototypes (should only include what is used here only)
//--------------------------------------------------------------------
void interrupt_service_routine ();
void close ();
void open ();
void optocouple ();
void main_init ();
void alert (); // for warning period before close
void led_strip();
void seven_seg();
void encoder();
// END PROTOTYPES ********************************************************

//--------------------------------------------------------------------
/// things still to do:
// Sensitivity sensor, current sensor - which can now be done with the 0.1ohm current sense res
// do the lcd functions with only one function, but using pointers to strings ? / ? ? ? ?
// sort out being able to switch the PEC off (and not having to use a resistor ! ! !
// the sensor off / on

main ()
{
main_init ();    // CALL INITIALISE FUNCTION


emstop(); // poll the em stop terminals, adc pin 5, ANA3  

start_up = 1;

while (1==1)    //loop forever
{

emstop(); // poll the em stop terminals, adc pin 5, ANA3
  
  
light_on = 1;
led_strip();

encoder();




   // PIE1bits.TMR2IE = 0;
 //   PIE1bits.TMR1IE = 0;
//    PIE3bits.TMR4IE = 0;    

// EM STOP FINE WHILE LOOP ***********************************************************************
    //*********************************************************************************************

while (advalue10 > EM_STOP) // while em stop is fine
    {
emstop(); // poll the em stop terminals, adc pin 5, ANA3
light_on = 1;
led_strip();


if(prog_menu == 0)
{
// break from loop if emstop signal is low
if (advalue10<=EM_STOP)
{
seven_seg();
status_a = 201;
status_b = 201;    
break;
}
}
    




//  I   S   R           O   P   E   N *******************************************************************

if (top_limits_reached == 0 && open_isr == 1) // open after isr ose / 8k2 / pec interrupt
{


newtoggle = 2;

counter = 0; // reset the runtimer counter
//alarmarm = 0; // can't turn alarm off by activating ISR
open ();
}


if (top_limits_reached == 0 && open_isr == 2) // open after isr ose / 8k2 / pec interrupt
{
newtoggle = 2;
open ();
}


if(pec_fail == 1) // action on PEC during opening, anti-lift
{
    newtoggle = 1;
    close();
}


  //  PIE1bits.TMR2IE = 0;
   //PIE1bits.TMR1IE = 0;
   // PIE3bits.TMR4IE = 0;    

encoder(); // function for using the encoder; to enter the programming menu


if(prog_menu == 0 && safety1 == 0)
{
if(while_prog_ose == 0)
{
ose_state1();
}

if(status_a != 200)
{
    status_a1 = status_a;
    status_b1 = status_b;
}

if(ose_test == 0)
{
    status_a = 200;
    status_b = 200;
}

if(ose_test == 1)
{
    status_a = status_a1;
    status_b = status_b1;
}
}





if(prog_menu == 0)
{
    {
pec_state();
}


if(status_a != 202)
{
    status_a2 = status_a;
    status_b2 = status_b;
}
if(pec_test == 0)
{
    status_a = 202;
    status_b = 202;
}
if(pec_test == 1)
{
    status_a = status_a2;
    status_b = status_b2;
}
}



if(prog_menu == 1 && defalt == 1  && DOWNSWITCH == 1 && UPSWITCH == 1)
{
    status_a = 101;
    status_b = 101;
    
    __delay_ms (2000);
    
if(defalt == 1  && DOWNSWITCH == 1 && UPSWITCH == 1)    
{
    di();
//EEPROM_WRITE(0x0, 0x00); // Empty
// EEPROM_WRITE(0x1, 0x01);  // RX TX     
EEPROM_WRITE(0x2, 0x63);  // Edge exclusion zone
//    __delay_ms (30);
EEPROM_WRITE(0x3, 0x00);  // Run mode     
//    __delay_ms (30);
EEPROM_WRITE(0x4, 0x28);  // Run timer
//    __delay_ms (30);
EEPROM_WRITE(0x5, 0x00); // edge activation
//    __delay_ms (30);
//EEPROM_WRITE(0x6, 0x00); // cycle
//EEPROM_WRITE(0x7, 0x00); // cycle
EEPROM_WRITE(0x8, 0x00); // open time for autoclose
//    __delay_ms (30);
EEPROM_WRITE(0x9, 0x00); // stall detec on/ off
//    __delay_ms (30);
//EEPROM_WRITE(0xA, 0x00); // stall diagnose mode
EEPROM_WRITE(0xB, 0x03); // minutes for light
//    __delay_ms (30);
EEPROM_WRITE(0xC, 0xC8); // stall threshold
//    __delay_ms (30);
//EEPROM_WRITE(0xD, 0x00); // delete all transmitters
EEPROM_WRITE(0xE, 0x00); // edge reverse method
EEPROM_WRITE(0xF, 0x00); // edge reverse method
//    __delay_ms (30);
//EEPROM_WRITE(0xF, 0x00); // set defaults
defalt = 0;
ei();
}
}







    // D    E   B   O   U   N   C   E       L   O   O   P       A   N   D       C  A   P   S   E   N   S   E ***************************
do
{
    
 
    
if (SWITCHRF == LOW && UPSWITCH == LOW && DOWNSWITCH == LOW && EXTUP == LOW && EXTDOWN == LOW && advalue10 > EM_STOP)
{
    count_low++;
    count_high = NULL;

}
else
{
    count_low = NULL;
    count_high++;
}
//wait til pin has been at same level for 20ms
}
while (count_low< COUNT_TARGET && count_high < COUNT_TARGET);
if (count_high >= COUNT_TARGET && count_high < COUNT_TARGET20)





// *************END  debounce ****************

emstop(); // poll the em stop terminals, adc pin 5, ANA3

light_on = 1;
led_strip();


   
    
    
    
    
// reset the button press, so that it does not carry over

if(SWITCHRF == 0 && UPSWITCH ==0 && DOWNSWITCH == 0 && EXTUP == 0 && EXTDOWN == 0 && runmenu == 1 && prog_menu == 0)
{
    runmenu = 0; // finger press release or press still
}


    
    
    

// GET OUT of this debounce while loop IF the emergency stop result is low
if(prog_menu == 0)
{
if (advalue10<=EM_STOP)
{
seven_seg();
status_a = 201;
status_b = 201;    
break;
}
}















// A    U   T   O   C   L   O   S   E   ******************************************


if(bottom_limits_reached == 0 && stop_state == 1 && run_mode == 0 && open_time >0 && prog_menu == 0 && start_up == 0) // if opentime_flag is greater than zero, this will autoclose  ---- used to have ' '
            // and a count down********************************
{
newtoggle = 1; /// SHOULDN'T THIS BE 2 FOR THE KEYSWITCH TO WORK? SEE BELOW
counter = 0;
if (count_down_marker ==1)
{
countdown();
}

} // end stop_state == 1;











// F   U   L   L        A  U  T  O  M  A  T  I  C       S   I   N   G   L   E         S     W   I   T   C   H    ***************************************************************
// ALSO INCLUDES THE OPEN FOR SEMI-AUTO
    
if (top_limits_reached == 0 && limit_setting == 0 && (SWITCHRF ==1) && oldtoggle == 1 && runmenu == 0&& prog_menu == 0 && (run_mode == 1 || run_mode == 0))
{
    runt();
emstop(); // poll the em stop terminals, adc pin 5, ANA3
newtoggle = 2;
counter = 0; // reset the runtimer counter
open (); // OPEN
led_strip();
}

if ( bottom_limits_reached == 0 && limit_setting == 0 && (SWITCHRF==1) && oldtoggle == 2 && runmenu == 0&& prog_menu == 0 && run_mode == 0) // only impulse close in run_mode = 1 or 2
{
emstop(); // poll the em stop terminals, adc pin 5, ANA3
newtoggle = 1;
counter = 0;
cycle_eeprom();
close(); // CLOSE
led_strip();
}






// F   U   L   L         A  U  T  O  M  A  T  I  C          T    R   I   P   L   E       S   W   I   T   C   H       **************************************************************
// ALSO INCLUDES THE OPEN FOR SEMI-AUTO
    
if (top_limits_reached == 0 && limit_setting == 0 && ((UPSWITCH == 1 || EXTUP==1)&& STOPSWITCH == 0) && prog_menu == 0 && (run_mode == 1 || run_mode == 0))
{
emstop(); // poll the em stop terminals, adc pin 5, ANA3
newtoggle = 2;
counter = 0;
open ();
led_strip();
}

if (bottom_limits_reached ==0 && limit_setting == 0 && ((DOWNSWITCH == 1 || EXTDOWN == 1) && STOPSWITCH == 0 && PEC == 1) && prog_menu == 0 && (run_mode == 0))
{
emstop(); // poll the em stop terminals, adc pin 5, ANA3
newtoggle = 1;
counter = 0;
cycle_eeprom();
close();
led_strip();
}




    
// D    E   A    D   M   A   N  FOR THE   T    R   I   P   L   E       S   W   I   T   C   H   ****************************************************

// CLOSE CLOSE
    if ((move_down_flag == 0 && ((DOWNSWITCH == 1 || EXTDOWN == 1) && STOPSWITCH == 0 && PEC == 1)
            && runmenu == 0&& prog_menu == 0 && (run_mode == 1 || run_mode == 2))|| (move_down_flag == 0 && DOWNSWITCH == 1 && limit_setting == 1)) // only impulse close in run_mode = 1 or 2
{
__delay_ms (10);
cycle_eeprom();
    move_down_flag = 1;
}
    
 if((((DOWNSWITCH == 1 || EXTDOWN == 1) && move_down_flag == 1)) || (move_down_flag == 1 && DOWNSWITCH == 1 && limit_setting == 1))
 {
     __delay_ms(200); // debounce
if((((DOWNSWITCH == 1 || EXTDOWN == 1) && move_down_flag == 1)) || (move_down_flag == 1 && DOWNSWITCH == 1 && limit_setting == 1))
{
light_on = 1;
light_setup = 1;
led_strip();     
     RELAY1 = 1;  
     status_a = 102;
    status_b = 102;
        if(safety1 == 0 && limit_setting == 0)
        {

     ose_state ();
    // sample the OSE and clear timer if functioning
    if (ose_test == 0 && safety1 == 0 && while_prog_safety == 0)
    {
        end_close = 1;
    }
 }
 }
 }
 if(SWITCHRF == 0 && DOWNSWITCH == 0 && EXTDOWN==0 && move_down_flag == 1)
 {
     RELAY1 = 0;
     move_down_flag = 0; 
newtoggle = 1;
counter = 0;   
            up = 1;
            down = 0;
    runmenu = 1;
    oldtoggle = newtoggle;
    counter = 0;     
     status_a = 105;
    status_b = 105;    
 }    
 if(end_close == 1)
 {
  RELAY1 = 0;
     move_down_flag = 0; 
newtoggle = 1;
counter = 0;   
            up = 1;
            down = 0;
    runmenu = 1;
    oldtoggle = newtoggle;
    counter = 0;   
    end_close = 0;
 }
    
    

     
   // OPEN OPEN
if ((move_up_flag == 0 &&((UPSWITCH == 1 || EXTUP==1) && STOPSWITCH == 0) 
        && runmenu == 0 && prog_menu == 0 && (run_mode == 2))|| (move_up_flag == 0 && UPSWITCH == 1 && limit_setting == 1))
{
__delay_ms (10);
    move_up_flag = 1;    
}
 if(((UPSWITCH == 1 || EXTUP==1) && move_up_flag == 1)|| (move_up_flag == 0 && UPSWITCH == 1 && limit_setting == 1))
 {
     __delay_ms(20); // debounce   
 if(((UPSWITCH == 1 || EXTUP==1) && move_up_flag == 1)|| (move_up_flag == 0 && UPSWITCH == 1 && limit_setting == 1))
 {  
light_on = 1;
light_setup = 1;
led_strip();     
     RELAY2 = 1;
     __delay_ms (200);
     RELAY1 = 1; 
     status_a = 103;
    status_b = 103;
 }
 }
 if(SWITCHRF == 0 && UPSWITCH == 0 && EXTUP==0 && move_up_flag == 1)
 {
     RELAY1 = 0;
     RELAY2 = 0;
     move_up_flag = 0; 
     status_a = 104;
    status_b = 104; 
 
 
    counter = 0;
    runmenu = 1;
newtoggle = 2;
    oldtoggle = newtoggle;
    up = 0; 
    down = 1; // flag for ensuring close cannot happen when door shut
    open_isr = 0; 
 }   

    
    

    
    
    
    
    
  

 


// D    E   A    D   M   A   N  FOR THE   S  I  N  G  L  E       S   W   I   T   C   H      ****************************************************    
// CLOSE CLOSE
    if ((move_down_flag == 0 && ((SWITCHRF==1) && STOPSWITCH == 0 && PEC == 1)
            && oldtoggle == 2 && runmenu == 0&& prog_menu == 0 && (run_mode == 1 || run_mode == 2))) // only impulse close in run_mode = 1 or 2
{
__delay_ms (10);
cycle_eeprom();
    move_down_flag = 1;
}
    
 if((((SWITCHRF==1) && move_down_flag == 1)))
 {
light_on = 1;
light_setup = 1;
led_strip();     
     __delay_ms(200); // debounce
     RELAY1 = 1;  
     status_a = 102;
    status_b = 102;
        if(safety1 == 0 && limit_setting == 0)
        {

     ose_state ();
    // sample the OSE and clear timer if functioning
    if (ose_test == 0 && safety1 == 0 && while_prog_safety == 0)
    {
        end_close = 1;
    }
 }
 }
 if(SWITCHRF == 0 && DOWNSWITCH == 0 && UPSWITCH == 0 && EXTUP == 0 && EXTDOWN == 0 && move_down_flag == 1)
 {
     RELAY1 = 0;
     move_down_flag = 0; 
newtoggle = 1;
counter = 0;   
            up = 1;
            down = 0;
    runmenu = 1;
    oldtoggle = newtoggle;
    counter = 0;     
     status_a = 105;
    status_b = 105;    
 }    
 if(end_close == 1)
 {
  RELAY1 = 0;
     move_down_flag = 0; 
newtoggle = 1;
counter = 0;   
            up = 1;
            down = 0;
    runmenu = 1;
    oldtoggle = newtoggle;
    counter = 0;   
    end_close = 0;
 }
    
    

     
   // OPEN OPEN
if ((move_up_flag == 0 &&((SWITCHRF ==1) && STOPSWITCH == 0) && oldtoggle == 1 
        && runmenu == 0 && up == 1&& prog_menu == 0 && (run_mode == 2)))
{
__delay_ms (10);
    move_up_flag = 1;   
}
 if(((SWITCHRF ==1) && move_up_flag == 1))
 {
light_on = 1;
light_setup = 1;
led_strip();
     __delay_ms(20); // debounce     
     RELAY2 = 1;
     __delay_ms (200);
     RELAY1 = 1;    
     status_a = 103;
    status_b = 103;
 }
 if(SWITCHRF == 0 && DOWNSWITCH == 0 && UPSWITCH == 0 && EXTUP == 0 && EXTDOWN == 0 && move_up_flag == 1)
 {
     RELAY1 = 0;
     __delay_ms (200);
     RELAY2 = 0;
     move_up_flag = 0; 
     status_a = 104;
    status_b = 104; 
    counter = 0;
    runmenu = 1;
newtoggle = 2;
    oldtoggle = newtoggle;
    up = 0; 
    down = 1; // flag for ensuring close cannot happen when door shut
    open_isr = 0; 
 }   

    













    
    
    
    
    
    
    
    
    
} // end while emstop ok



// A    C   T   I   O   N          O    N           E   M       S   T   O   P   *********************


while (advalue10<=EM_STOP && prog_menu == 0) // if em stop is fail, terminals
{
emstop(); // poll the em stop terminals, adc pin 5, ANA3
encoder();
seven_seg();
status_a = 201;
status_b = 201;
if(advalue10>EM_STOP || prog_menu == 1)
{
        break;
}

} // end while emstop fail





} // end while
} // end main

















// I    N   I   T   I   A   L   I   S   A   T   I   O   N ************************************

void main_init()
    {

        mainmenu = 1;
        post_reset = 1;
        button_state = 0;
        up = 1; // allow movement up with keyswitch from startup
        down = 1; // allow movement down with keyswitch from startup

        OPTION_REG = 0b10000001; // ENABLE WEAK PULL UPS, AND NO PRESCALER ON TMR0
                                 // OTHERWISE, THE DIPS DO NOT READ PROPERLY
        CM1CON0 = 0;    // Initialise comparator 1 OFF
        CM2CON0 = 0;    // Initialise comparator 2 OFF

        FVRCON = 0b10000011; // ENABLE INTERNAL VREF

        TRISA = 0b10011111;
        TRISB = 0b00000000; // SEVEN SEGS, AS OUTPUTS 
        TRISC = 0b11110010;
        TRISD = 0b00111000;
        TRISE = 0b00001110;

        //ADC SETTINGS: 0 = DIGITAL ; 1 = ANALOG

        ANSA0 = 0; 
        ANSA1 = 1; // optocoupler
        ANSA2 = 1; // em stop
        ANSA3 = 0;
        ANSA4 = 0;
        ANSA5 = 0;

        ANSB0 = 0;
        ANSB1 = 0;
        ANSB2 = 0;
        ANSB3 = 0;
        ANSB4 = 0;
        ANSB5 = 0;

        ANSD0 = 0;
        ANSD1 = 0;
        ANSD2 = 0;
        ANSD3 = 0;
        ANSD4 = 0;
        ANSD5 = 0; // CAP SENSE2
        ANSD6 = 0; // CAP SENSE1
        ANSD7 = 0;

        ANSE0 = 0; // for 8k2 stip, pin 8
        ANSE1 = 0;
        ANSE2 = 0;

        RELAY2      = 0;
        RELAY1      = 0;
        ALARM       = 0;


 
    // TMR1 uses 32 kHz external crystal
    T1GCON = 0x00;              // Ensure that T1 Gate is disabled
    T1CONbits.nT1SYNC = 1;      // Do not sync with system clock
    T1CONbits.TMR1CS = 0b10;    // external clock as source
    T1CONbits.T1OSCEN = 1;      // enable oscillator driver
    T1CONbits.T1CKPS = 0;       // 1:1 prescaler
    TMR1IF = 0;
    TMR1IE = 0;
    T1CONbits.TMR1ON = 1;
//INTCON = 0b00000000;
    
    
    exclusion_zone = EEPROM_READ(0x02);
    run_mode = EEPROM_READ(0x03); 
    runtimer = EEPROM_READ(0x04);
    safety1 = EEPROM_READ(0x05);  
    open_time = EEPROM_READ(0x08);
    current_detect = EEPROM_READ (0x09);    
    monitor_type = EEPROM_READ (0xA);
     light_flag = EEPROM_READ(0xB);   
    nm_threshold = EEPROM_READ(0xC);    
    reverse_method = EEPROM_READ (0xE);
    PEC_setting = EEPROM_READ(0xF);
    
    runmenu = 0;
    rootmenu = 0;
    auto_mode = 1;


    old_seg = 1;
    new_seg = 0;

    TMR0IF = 0;
    TMR0=0;
    TMR0IE = 1;
    PIE3bits.TMR4IE = 0;        

    
    
    
    
    
    INTCONbits.PEIE = 1; //
    INTCONbits.GIE = 1; //
    ei(); // enable interrupts
  

    status_a = 101;
    status_b = 101;
    
    __delay_ms (1700);

    status_a = 106;
    status_b = 106;
    
    
    // SET UP THE 7 SEG HERE, ONCE ONLY


    }// END INIT ()



// I    N   T   E   R   R   U   P   T   S   ************************************************

void interrupt isr()
{

        if(TMR0IF && prog_menu==0 && subroot == 0) // cycle for main menu programming
        {
            
        TMR0IE=0;
        TMR0IF=0;

        number++; // for flash, this is in use!

        seven_seg();
        
        unsigned char timer_max = 100;       // DETERMINES THE LENGTH OF FLASH DURING RUNNING TIME     
        
        
         oldLBUTTON = encoder_A;     // Store value for next time
        TMR0 = timer_max;                    // 200 Hz
        INTCONbits.TMR0IF = 0;          // Clear interrupt flag
        TMR0IE=1;         

        }      
    
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    
    
        if(TMR0IF && prog_menu==1 && subroot == 0 && MBUTTON ==0) // cycle for main menu programming
        {
            
        TMR0IE=0;
        TMR0IF=0;
        TMR1ON = 0;
        TMR1IF = 0;
        TMR1IE = 0;
        
        TMR2ON = 0;
        TMR2IF = 0;
        TMR2IE = 0;        
        
        TMR4ON = 0;
        TMR4IF = 0;
        TMR4IE = 0;        
        
         TMR6ON = 0;       
        TMR6IF = 0;
        TMR6IE = 0;         

        number++; // for flash, this is in use!

        seven_seg();
        
        unsigned char timer_max = 130;        // TO CALIBRATE THE ENCODER TURNING    
        
        
        
         encoder_A = LBUTTON;
        encoder_B = RBUTTON;       
      
        

if((encoder_A != oldLBUTTON || encoder_B != oldRBUTTON) && timer2 == 0)
{
        char change = 0;
        timer = 0;
        
        // algorithm
        
        if(oldLBUTTON ==0 && oldRBUTTON == 0 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 0 && change == 0)
            {
                clockwise = 1;
                change = 1;
            }
            if(encoder_A == 0 && encoder_B == 1 && change == 0)
            {
                clockwise = 2;
                change = 1;                
            }            
        }
        

        if(oldLBUTTON ==1 && oldRBUTTON == 1 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 0 && change == 0)
            {
                clockwise = 2;
                change = 1;                
            }
            if(encoder_A == 0 && encoder_B == 1 && change == 0)
            {
                clockwise = 1;
                change = 1;                
            }            
        }


        if(oldLBUTTON ==1 && oldRBUTTON == 0 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 1 && change == 0 && clockwise == 1)
            {
                if(rootmenu<20)
                {
                rootmenu++;
                timer2 = 10;
                change = 1;   
                }
            }
            if(encoder_A == 0 && encoder_B == 0 && change == 0 && clockwise == 2)
            {
                if(rootmenu>0)
                {
                rootmenu--;
                timer2 = 10;                
                change = 1;   
                }
            }            
        }            
        if(oldLBUTTON ==0 && oldRBUTTON == 1 && change == 0)
        {
            if(encoder_A == 0 && encoder_B == 0 && change == 0 && clockwise == 1)
            {
                if(rootmenu<20)
                {
                rootmenu++;
                timer2 = 10;                
                change = 1;      
                }
            }
            if(encoder_A == 1 && encoder_B == 1 && change == 0 && clockwise == 2)
            {
                if(rootmenu >0)
                {
                rootmenu--;
                timer2 = 10;                
                change = 1;       
                }
            }            
        }  
}

           oldLBUTTON = encoder_A;     // Store value for next time
         oldRBUTTON = encoder_B;     // Store value for next time     
         if(timer2 >0)
         {
            timer2--; // stop further actions until countdown.              
         }
         
         
if(encoder_A == oldLBUTTON && encoder_B == oldRBUTTON)
{
  // no change
    timer ++;
    if(timer >=50)
    {
        timer = 0;
        clockwise = 0;
        change = 0;
    }
}        

        TMR0 = timer_max;                    // 200 Hz
        INTCONbits.TMR0IF = 0;          // Clear interrupt flag
        TMR0IE=1;         

        }    
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        if(TMR0IF && prog_menu==1 && MBUTTON) // cycle for main menu programming
        {
            
        TMR0IE=0;
        TMR0IF=0;
        TMR1ON = 0;
        TMR2ON = 0;
        TMR4ON = 0;
        TMR6ON = 0;        

        number++; // for flash, this is in use!

        seven_seg();
        
        unsigned char timer_max = 100;            
        

        TMR0 = timer_max;                    // 200 Hz
        INTCONbits.TMR0IF = 0;          // Clear interrupt flag
        TMR0IE=1;         

        }        
    
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    
    if(TMR0IF && prog_menu ==1 && subroot != 0)
    {
        TMR0IE=0;
        TMR0IF=0;
        TMR1ON = 0;
        TMR1IF = 0;
        TMR1IE = 0;
        
        TMR2ON = 0;
        TMR2IF = 0;
        TMR2IE = 0;        
        
        TMR4ON = 0;
        TMR4IF = 0;
        TMR4IE = 0;        
        
         TMR6ON = 0;       
        TMR6IF = 0;
        TMR6IE = 0;         

        number++; // for flash, this is in use!

        seven_seg();
        
        unsigned char timer_max = 130;        // TO CALIBRATE THE ENCODER TURNING    
        
        
        
         encoder_A = LBUTTON;
        encoder_B = RBUTTON;   


        if(prog_menu==1 && (rootmenu == 1 || rootmenu == 6 || rootmenu == 7 || rootmenu == 12 || rootmenu == 13 || rootmenu == 14 || rootmenu == 15 || rootmenu == 17 || rootmenu == 18
                || rootmenu == 19 || rootmenu == 20) && subroot == 1) // cycle for sub menu, opentime (autoclose period)
        {
                out=0;
        encoder_A = LBUTTON;
        encoder_B = RBUTTON;

        if((!encoder_A) && (oldLBUTTON)){

            // A has gone from high to low
            if(encoder_B) {
                // B is high so clockwise

                out=0;
            }
            else {
                // B is low so counter-clockwise

                out = 0;
            }
        }
        }

        
        
 if(rootmenu == 2 || rootmenu == 3 ||rootmenu == 4 ||rootmenu == 5 ||rootmenu == 8 ||rootmenu == 9 ||rootmenu == 10 ||rootmenu == 11 ||rootmenu == 14 ||rootmenu == 15 ||rootmenu == 16)   
 {
if((encoder_A != oldLBUTTON || encoder_B != oldRBUTTON) && timer2 == 0)
{
        char change = 0;
        timer = 0;
        
        // algorithm
        
        if(oldLBUTTON ==0 && oldRBUTTON == 0 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 0 && change == 0)
            {
                clockwise = 1;
                change = 1;
            }
            if(encoder_A == 0 && encoder_B == 1 && change == 0)
            {
                clockwise = 2;
                change = 1;                
            }            
        }
        

        if(oldLBUTTON ==1 && oldRBUTTON == 1 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 0 && change == 0)
            {
                clockwise = 2;
                change = 1;                
            }
            if(encoder_A == 0 && encoder_B == 1 && change == 0)
            {
                clockwise = 1;
                change = 1;                
            }            
        }


        if(oldLBUTTON ==1 && oldRBUTTON == 0 && change == 0)
        {
            if(encoder_A == 1 && encoder_B == 1 && change == 0 && clockwise == 1)
            {
                if(rootmenu==2 && exclusion_zone<99)
                {
                exclusion_zone++;
                }
                if(rootmenu==3 && run_mode<2)
                {
                run_mode++;
                }      
                if(rootmenu==4 && runtimer<99)
                {
                runtimer++;
                }                
                if(rootmenu==5 && safety1<2)
                {
                safety1++;
                }            
                if(rootmenu==8 && open_time<99)
                {
                open_time++;
                }  
                if(rootmenu==9 && current_detect<1)
                {
                //current_detect++;
                    ;
                } 
                if(rootmenu==10 && monitor_type<3)
                {
                //monitor_type++;
                    ;
                }   
                if(rootmenu==11 && light_flag<5)
                {
                light_flag++;
                }  
                if(rootmenu==14 && reverse_method<1)
                {
                reverse_method++;
                }           
                if(rootmenu==15 && defalt<1)
                {
                defalt++;
                }   
                if(rootmenu==16 && PEC_setting<1)
                {
                PEC_setting++;
                }                
                timer2 = 10;
                change = 1;       
            }
            if(encoder_A == 0 && encoder_B == 0 && change == 0 && clockwise == 2)
            {
                if(rootmenu==2 && exclusion_zone>0)
                {
                exclusion_zone--;
                }                
                if(rootmenu==3 && run_mode>0)
                {
                run_mode--;
                }      
                if(rootmenu==4 && runtimer>0)
                {
                runtimer--;
                }                
                if(rootmenu==5 && safety1>0)
                {
                safety1--;
                }            
                if(rootmenu==8 && open_time>0)
                {
                open_time--;
                }  
                if(rootmenu==9 && current_detect>0)
                {
                current_detect--;
                } 
                if(rootmenu==10 && monitor_type>0)
                {
                monitor_type--;
                }   
                if(rootmenu==11 && light_flag>0)
                {
                light_flag--;
                }  
                if(rootmenu==14 && reverse_method>0)
                {
                reverse_method--;
                }           
                if(rootmenu==15 && defalt>0)
                {
                defalt--;
                }   
                if(rootmenu==16 && PEC_setting>0)
                {
                PEC_setting--;
                }  
                timer2 = 10;                
                change = 1;                  
            }            
        }            
        if(oldLBUTTON ==0 && oldRBUTTON == 1 && change == 0)
        {
            if(encoder_A == 0 && encoder_B == 0 && change == 0 && clockwise == 1)
            {
                if(rootmenu==2 && exclusion_zone<99)
                {
                exclusion_zone++;
                }
                if(rootmenu==3 && run_mode<2)
                {
                run_mode++;
                }      
                if(rootmenu==4 && runtimer<99)
                {
                runtimer++;
                }                
                if(rootmenu==5 && safety1<2)
                {
                safety1++;
                }            
                if(rootmenu==8 && open_time<99)
                {
                open_time++;
                }  
                if(rootmenu==9 && current_detect<1)
                {
                //current_detect++;
                    ;
                } 
                if(rootmenu==10 && monitor_type<3)
                {
               // monitor_type++;
                    ;
                }   
                if(rootmenu==11 && light_flag<5)
                {
                light_flag++;
                }  
                if(rootmenu==14 && reverse_method<1)
                {
                reverse_method++;
                }           
                if(rootmenu==15 && defalt<1)
                {
                defalt++;
                }   
                if(rootmenu==16 && PEC_setting<1)
                {
                PEC_setting++;
                }         
                timer2 = 10;
                change = 1;                   
            }
            if(encoder_A == 1 && encoder_B == 1 && change == 0 && clockwise == 2)
            {
                if(rootmenu==2 && exclusion_zone>0)
                {
                exclusion_zone--;
                }                
                if(rootmenu==3 && run_mode>0)
                {
                run_mode--;
                }      
                if(rootmenu==4 && runtimer>0)
                {
                runtimer--;
                }                
                if(rootmenu==5 && safety1>0)
                {
                safety1--;
                }            
                if(rootmenu==8 && open_time>0)
                {
                open_time--;
                }  
                if(rootmenu==9 && current_detect>0)
                {
                current_detect--;
                } 
                if(rootmenu==10 && monitor_type>0)
                {
                monitor_type--;
                }   
                if(rootmenu==11 && light_flag>0)
                {
                light_flag--;
                }  
                if(rootmenu==14 && reverse_method>0)
                {
                reverse_method--;
                }           
                if(rootmenu==15 && defalt>0)
                {
                defalt--;
                }   
                if(rootmenu==16 && PEC_setting>0)
                {
                PEC_setting--;
                } 
                timer2 = 10;                
                change = 1;                 
            }            
        }  
}       
out = 0;
    }        

      
           oldLBUTTON = encoder_A;     // Store value for next time
         oldRBUTTON = encoder_B;     // Store value for next time     
         if(timer2 >0)
         {
            timer2--; // stop further actions until countdown.              
         }
         
         
if(encoder_A == oldLBUTTON && encoder_B == oldRBUTTON)
{
  // no change
    timer ++;
    if(timer >=50)
    {
        timer = 0;
        clockwise = 0;
        change = 0;
    }
}        

        TMR0 = timer_max;                    // 200 Hz
        INTCONbits.TMR0IF = 0;          // Clear interrupt flag
        TMR0IE=1;            
        
   
    }

        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    
if (TMR1IF && TMR1IE) // Timer 1 for run counting and leds
    {
        TMR1IF = 0;
        TMR1IE = 0;
        counter++;
        peaks_per_second_conf = peaks_per_second;
        peaks_per_second = 0;

        if(light_on == 1)
        {
        light_time--;
        }
        if(countdown_close == 1)
        {
        open_time--;
        }
        TMR1 = 32700;// set the clock half way complete, which means 1 second
        TMR1IE = 1;
    }


if (TMR2IF && TMR2IE && (safety1 == 0 || safety1 == 1)) // Timer 2 for OSE / 8k2 timing
    {
            TMR2ON = 0;
            TMR2IF = 0;
            TMR2IE = 0;
            
            TMR6ON = 0;
            TMR6IF = 0;
            TMR6IE = 0;            
            RELAY1 = 0;
            RELAY2 = 0;
            status_a = 200;
            status_b = 200;
        seven_seg();            
            __delay_ms(200);
            newtoggle = 2;
reverse_method = EEPROM_READ (0xE); 

            if(reverse_method == 1)
            {             
    open_isr = 1; // This directs the processor to an open function call in the main ()     
            }
            else
            {
     RELAY2 = 1;
     __delay_ms (200);
     RELAY1 = 1; 
        status_a = 200;
        status_b = 200;  
        seven_seg();        
                __delay_ms (2000);
                RELAY1 = 0;
                __delay_ms (200);
                RELAY2 = 0;
            }

     } // END TMR2 OSE CUT OUT


    
    
    
    
if (TMR4IF && TMR4IE) // Timer 4, for stall monitoring
    {
  //  unsigned char maxval;
    
            TMR4ON = 0;
            TMR4IF = 0;
            TMR4IE = 0;
//maxval1 =0;

    char x;    
    FVRCON = 0b10000011; // ENABLE INTERNAL VREF
    __delay_us (300); // TO ALLOW FVR TO CHARGE UP
    ADCON0 = 0b00000101; // ANA1 CHANNEL, pin 3, (RA1), AND ENABLED
    ADON = 1;            // SWITCH ON
    ADCON1 = 0b00100011; //HERE IT IS SET TO READ OFF INTERNAL 5V REFERENCE


            ADGO = 1; // TURN ON THE ADC
    while (ADGO == 1); // WAIT WHILE CONVERSION TAKES PLACE
    

    maxval_new = ADRESH;   // ASSIGN NAME TO RESULT
    read=1; // new read to send
    
choose();

   // get_highest();



}
    

if (TMR6IF && TMR6IE) // Timer 2 for OSE / 8k2 timing
    {
            TMR6ON = 0;
            TMR6IF = 0;
            TMR6IE = 0;
            TMR2ON = 0;
            TMR2IF = 0;
            TMR2IE = 0;            
            
            RELAY1 = 0;
            RELAY2 = 0;
            status_a = 202;
            status_b = 202;
        
            __delay_ms(200);
            newtoggle = 2;



            open_isr = 2;
            

     } // END TMR2 OSE CUT OUT

} // END ISR


